      subroutine fulout(iout, e, c, n, nv, kod, maxcol)
c
c     If kod = 1 prints nv eigenvalues (e) and eigenvectors (c) of
c     a n x n matrix, using maxcol columns. If kod = 2 prints
c     only nv eigenvectors (c).
c
      implicit real*8 (a-h, o-z)
      dimension e(*), c(*)
      nprint = nv / maxcol
      do 20 k = 1, nprint + 1
        if (k.le.nprint) then
          jl = (k - 1) * maxcol + 1
          jh = k * maxcol
        else
          jl = nprint * maxcol + 1
          jh = nv
        endif
        if (jl.le.jh) then
          write (iout, 1001) (j,    j = jl, jh)
          if (kod.eq.1) write (iout, 1002) (e(j), j = jl, jh)
          write (iout, *)
          do 10 i = 1, n
   10     write (iout, 1003) i, (c(i + (j - 1) * n), j = jl, jh)
          write (iout, *)
        endif
   20 continue
c
      return
 1001 format(' ', 3x,  255(i9, 3x))
 1002 format(' ', 3x,  255(f12.6))
 1003 format(' ', i3,  255(f12.6))
      end
c
c----------------------------------------------------------------------
c
      subroutine utout(iout, r, n, kod, maxcol)
c
c     Prints all the the upper triangle of a n x n symmetric matrix,
c     using maxcol columns. If kod = 1 the matrix is in upper
c     triangular form, ordered by columns, if kod = 2 it is in
c     upper triangular from ordered by rows, and if kod = 3, it
c     is a full matrix, ordered by rows (standard Fortran).
c
      implicit real*8 (a-h, o-z)
      character*40 fstr
      character*4  nestr
      dimension r(*)
      nprint = n / maxcol
      nrest = mod(n, maxcol)
      jl = 1
      jh = nrest
      do 30 k = 0, nprint
        if (jl.le.jh) then
          write (iout, 1001) (j, j = jl, jh)
          write (iout, *)
          do 20 i = 1, nrest + k * maxcol
            if (i.le.jl) then
              if (kod.eq.1) then
                write (iout, 1002)
     .            i, (r(i + j*(j - 1)/2), j = jl, jh)
              elseif (kod.eq.2) then
                write (iout, 1002)
     .            i, (r((i - 1)*(2*n - i)/2 + j), j = jl, jh)
              elseif (kod.eq.3) then
                write (iout, 1002)
     .            i, (r(i + (j - 1)*n), j = jl, jh)
              endif
            else
              nempty = i - jl
              write (nestr, '(i4)') nempty
              fstr = '('' '', i3,' // nestr // '(12x), 255(f12.6))'
              if (kod.eq.1) then
                write (iout, fstr)
     .            i, (r(i + j*(j - 1)/2), j = i, jh)
              elseif (kod.eq.2) then
                write (iout, fstr)
     .            i, (r((i - 1)*(2*n - i)/2 + j), j = i, jh)
              elseif (kod.eq.3) then
                write (iout, fstr)
     .            i, (r(i + (j - 1)*n), j = i, jh)
              endif
            endif
   20     continue
          write (iout, *)
        endif
        jl = jh + 1
        jh = jl + maxcol - 1
   30 continue
c
      return
 1001 format(' ', 3x, 255(i9, 3x))
 1002 format(' ', i3, 255(f12.6))
      end
